/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.metrics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net;
import com.badlogic.gdx.net.HttpRequestBuilder;
import com.google.gson.Gson;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.ExceptionHandler;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.daily.TimeHelper;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveAndContinue;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LeaderboardPoster
implements Runnable {
    private static final Logger logger = LogManager.getLogger(LeaderboardPoster.class.getName());
    private Gson gson = new Gson();
    private String url = "https://slack-feedback-bot.herokuapp.com";
    private LeaderboardDataType type;
    private String logs;
    private String header;
    private ArrayList<String> data;
    private boolean didFight;

    public void setValues(LeaderboardDataType type, String logs, String header, ArrayList<String> data, boolean didFight) {
        this.type = type;
        this.logs = logs;
        this.header = header;
        this.data = data;
        this.didFight = didFight;
    }

    public void sendPost(HashMap<String, Serializable> eventData) {
        HashMap<String, Serializable> event = new HashMap<String, Serializable>();
        try {
            String hostname = InetAddress.getLocalHost().getHostName();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(hostname.getBytes());
        }
        catch (UnknownHostException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            ExceptionHandler.handleException(e, logger);
        }
        event.putAll(eventData);
        String data = this.gson.toJson(event);
        logger.info("UPLOADING TO LEADER BOARD: " + data);
        HttpRequestBuilder requestBuilder = new HttpRequestBuilder();
        Net.HttpRequest httpRequest = requestBuilder.newRequest().method("POST").url(this.url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        httpRequest.setContent(data);
        Gdx.net.sendHttpRequest(httpRequest, new Net.HttpResponseListener(){

            @Override
            public void handleHttpResponse(Net.HttpResponse httpResponse) {
            }

            @Override
            public void failed(Throwable t) {
            }

            @Override
            public void cancelled() {
            }
        });
    }

    public void gatherDemoEmbarkDataAndSend() {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(3);
        data.put("event type", (Serializable)((Object)"prod run"));
        data.put("player", (Serializable)((Object)(CardCrawlGame.playerName + " playing build " + CardCrawlGame.TRUE_VERSION_NUM)));
        this.sendPost(data);
    }

    public void gatherCrashDataAndSend(String logs) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("event type", (Serializable)((Object)"crash log"));
        if (Settings.isBeta) {
            data.put("player", (Serializable)((Object)CardCrawlGame.playerName));
        } else {
            data.put("player", (Serializable)((Object)CardCrawlGame.alias));
        }
        data.put("build", (Serializable)((Object)CardCrawlGame.TRUE_VERSION_NUM));
        data.put("crash log", (Serializable)((Object)logs));
        data.put("save file", (Serializable)((Object)SaveAndContinue.loadSaveString(AbstractDungeon.player.chosenClass)));
        this.sendPost(data);
        logger.info("crash log data sent");
    }

    public void gatherLeaderboardDataAndSend(boolean death) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(3);
        data.put("event type", (Serializable)((Object)"game end"));
        data.put("character", (Serializable)((Object)AbstractDungeon.player.chosenClass.name()));
        data.put("win", Boolean.valueOf(!death));
        if (Settings.isBeta) {
            if (CardCrawlGame.playerName.contentEquals("<no name>")) {
                data.put("player", (Serializable)((Object)"anonymous"));
            } else {
                data.put("player", (Serializable)((Object)CardCrawlGame.playerName));
            }
        } else {
            data.put("player", (Serializable)((Object)CardCrawlGame.alias));
        }
        data.put("floor", Integer.valueOf(AbstractDungeon.floorNum));
        data.put("is_hardmode", Boolean.valueOf(false));
        this.sendPost(data);
    }

    public void gatherDailyDataAndSend() {
        if (!Settings.isDebug) {
            HashMap<String, Serializable> data = new HashMap<String, Serializable>(3);
            data.put("event type", (Serializable)((Object)"daily score"));
            if (Settings.isBeta) {
                data.put("player", (Serializable)((Object)CardCrawlGame.playerName));
            } else {
                data.put("player", (Serializable)((Object)CardCrawlGame.alias));
            }
            data.put("date", Long.valueOf(TimeHelper.daySince1970));
            data.put("score", Integer.valueOf(AbstractDungeon.floorNum));
            this.sendPost(data);
        }
    }

    public void gatherBanditDataAndSend(boolean didFight) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(3);
        data.put("event type", (Serializable)((Object)"bandits"));
        data.put("character", (Serializable)((Object)AbstractDungeon.player.chosenClass.name()));
        if (Settings.isBeta) {
            data.put("player", (Serializable)((Object)CardCrawlGame.playerName));
        } else {
            data.put("player", (Serializable)((Object)CardCrawlGame.alias));
        }
        data.put("money", Integer.valueOf(AbstractDungeon.player.gold));
        data.put("didFightBandits", Boolean.valueOf(didFight));
        this.sendPost(data);
    }

    public void sendCardData(String header, ArrayList<String> cardData) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(cardData.size() + 1);
        data.put("event type", (Serializable)((Object)"card data update"));
        data.put("header", (Serializable)((Object)header));
        data.put("data", cardData);
        this.sendPost(data);
    }

    public void sendRelicData(String header, ArrayList<String> relicData) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(relicData.size() + 1);
        data.put("event type", (Serializable)((Object)"relic data update"));
        data.put("header", (Serializable)((Object)header));
        data.put("data", relicData);
        this.sendPost(data);
    }

    public void sendEnemyData(String header, ArrayList<String> enemyData) {
        HashMap<String, Serializable> data = new HashMap<String, Serializable>(enemyData.size() + 1);
        data.put("event type", (Serializable)((Object)"enemy data update"));
        data.put("header", (Serializable)((Object)header));
        data.put("data", enemyData);
        this.sendPost(data);
    }

    @Override
    public void run() {
        switch (this.type) {
            case BANDITS: {
                this.gatherBanditDataAndSend(this.didFight);
                break;
            }
            case CARD_DATA: {
                this.sendCardData(this.header, this.data);
                break;
            }
            case CRASH_DATA: {
                this.gatherCrashDataAndSend(this.logs);
                break;
            }
            case DAILY_DATA: {
                this.gatherDailyDataAndSend();
                break;
            }
            case DEMO_EMBARK: {
                this.gatherDemoEmbarkDataAndSend();
                break;
            }
            case ENEMY_DATA: {
                this.sendEnemyData(this.header, this.data);
                break;
            }
            case RELIC_DATA: {
                this.sendRelicData(this.header, this.data);
                break;
            }
            case VICTORY_DATA: {
                this.gatherLeaderboardDataAndSend(this.didFight);
                break;
            }
            default: {
                logger.info("Unspecified LeaderboardPosterType: " + this.type.name() + " in run()");
            }
        }
    }

    public static enum LeaderboardDataType {
        BANDITS,
        CRASH_DATA,
        DAILY_DATA,
        DEMO_EMBARK,
        VICTORY_DATA,
        CARD_DATA,
        ENEMY_DATA,
        RELIC_DATA;

    }
}

